const express = require('express');
const bodyParser = require('body-parser');
const app = express();
require('dotenv').config();
const http = require('http').createServer(app);
// const io = require('socket.io')(http);
const io = require('socket.io')(http,{
              cors: {
                origin: 'https://demo.dtlavleen.online',
                methods: ['GET', 'POST'],
                allowedHeaders: ['Content-Type'],
                credentials: true,
              },
            });
const path = require('path');
const mysql = require('mysql');
const multer = require('multer');
const { DateTime } = require('luxon');
const { exit } = require('process');
const fetch = require('node-fetch');
const tableName = 'live_message';
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());

// Specify the storage configuration for multer
const storage = multer.diskStorage({
  destination: path.join(__dirname, 'public/uploads'),
  filename: (req, file, cb) => {
    const fileNameWithoutExtension = path.parse(file.originalname).name;
    cb(null, `${fileNameWithoutExtension}-${Date.now()}${path.extname(file.originalname)}`);
  },
});
// Create the multer instance
const upload = multer({ storage: storage });
let onlineUsers2 = 0;
app.use(express.static(path.join(__dirname, 'public')));

// Create a MySQL connection pool
const pool = mysql.createPool({
  host: process.env.HOST,
  user: process.env.DATABASE_USER,
  password: process.env.DATABASE_PASSWORD,
  database: process.env.DATABASE_NAME
});
const userSocketMap = new Map();
var seenStatus = true; //global variable to minimize the DB hits
// Socket.IO connection
io.on('connection', (socket) => {
  console.log('A user connected');
  console.log(io.engine.clientsCount, " on connect ");
  // Join room
  socket.on('joinRoom', async (room) => {
    socket.join(room); // user will join the specified room
    console.log("room test : "+room);
    let check_data = await checkUserSideNewMessage(room)
    io.to(room).emit('message-notification', check_data);

  });
  
  // update user online status
  socket.on('set_online_status', (d) => {
    // updateOnline(socket.id,d.id);
    userSocketMap.set(socket.id, d.userId.toString());
    console.log(userSocketMap,"  On line status set : ",d)
    io.emit('refresh_status');
  });
  socket.on('get_online_status',(d)=>{
    setTimeout(()=>{
      let status = 0;
      const valuesArray = Array.from(userSocketMap.values());
      if (valuesArray.includes(d.receiver_id.toString())) {
        status = 1;
      }
      io.to(d.roomId).emit('get_online_status',{'roomId': d.roomId,'status':status, 'userId':d.receiver_id});
    },1500)
  });

  socket.on('userDataDetails', (d) => {
    // Fetch chat history from the database and send it to the connected user
    console.log("User History Data Payload: ", d)
    if (d.sender_id) {
      const query = `SELECT *,created_at AS timestamps, milli_timestamp AS created_at FROM ${tableName} WHERE room_id = ? AND deleted = 'false' ORDER BY id DESC`; // Change the query as needed
      pool.query(query, d.roomId, (error, results) => {
        if (error) {
          // console.error('Error fetching chat history:', error);
          console.log(error," line 80");
          return;
        }
        // Decode URI-encoded messages
        const decodedResults = results.map((result) => {
          // const isGreaterThan30Min = check30minFromNow(result.created_at);
          if(result.created_at === null){
            result.created_at = convertToMilliseconds(result.timestamps);
          }
          if(result.room_id != String(result.sender_id)){
            result.userType = 'admin';
          }else{
            result.userType = null;
          }
          const menu = check30minFromNow(result.created_at) ? ['Reaction'] : ['Reaction', 'Edit', 'Delete'];
          // const menu = isGreaterThan30Min ? ['Reaction'] : (result.type == 1 ? ['Reaction', 'Edit', 'Delete'] : ['Reaction','Edit', 'Delete']);
          return {
            ...result,
            message: safeDecodeURI(result.message),
            reaction: safeDecodeURI(result.reaction),
            menu,
          };
        });
        // console.log(decodedResults);
        if (decodedResults.length > 0) {
          const latestMessage = decodedResults[0];
          // if seen_status is true then the user has seen the message
          seenStatus = latestMessage.seen_status === 1;
          // console.log('Seen Status for ID in history 87:'+latestMessage.id+': ', latestMessage.seen_status);
        }
        // Reverse the array to display the latest messages first
        const chatHistory = {
          chat: decodedResults.reverse(),
          logged_in: d.receiver_id,
          client: d.sender_id,
          admin: d.name,
          user: d.user_name,
        };
        // console.log("history :", results)
        socket.emit('chatHistory', chatHistory);
        io.to(d.roomId).emit('message-notification', false);
      });
    }
  });

  // new message event for both
  socket.on('send-message', (data) => {
    console.log(data, 'testing')
    const currentTimestamp = Date.now();
    data.message = data.type == '1' ? encodeURI(data.message) : data.message;
    // console.log("message event listner: ", data);
    const query = `INSERT INTO ${tableName} (room_id,sender_id, receiver_id, message, type, seen_status, milli_timestamp, name) VALUES (?,?,?,?,?,?,?,?)`;
    const values = [
      data.room_id,
      data.sender_id,
      data.receiver_id,
      data.message,
      data.type,
      data.seen_status,
      data.created_at,
      // data.image,
      data.name,
      // data.userType,
    ];
    pool.query(query, values, async (err, result) => {
      if (err) {
        console.error('Error inserting message:', err);
        return;
      }
      //io.emit('add-messages', msg_a);
      data.id = result.insertId;
      data.reaction = 'null';
      // creating options for edit/delete based on 30mins from current time
      const createdAtTimestamp = parseInt(result.created_at);
      const isGreaterThan30Min = currentTimestamp - createdAtTimestamp > 30 * 60 * 1000;
      data.menu = isGreaterThan30Min ? ['Reaction'] : ['Reaction', 'Edit', 'Delete'];
      data.edited = 0;
      data.message = data.type == '1' ? safeDecodeURI(data.message) : data.message;
      io.to(data.room_id).emit('add-messages', data);
      io.to(data.room_id).emit('message-notification', true);
      // io.to(data.receiver_id).emit('message-notifications', true);
      console.log(data);
      // hard coding the admin room id here... later will change as per requirement.
      // if(data.receiver_id != data.room_id){
      //   io.to(320).emit('message-notifications', data.sender_id);
      // }
      try {
        var nameQuery = `SELECT name FROM users WHERE id = ?`;
        var nameVale = [
          data.sender_id
        ];
        pool.query(nameQuery, nameVale, (error, result) => {
          if (error) {
            console.log('error in query 168');
          }
          console.log("line 180  ",result);
          io.to(data.room_id).emit('message-notifications', {"id":data.sender_id, "name":result[0]['name'],"message":result[0]['name']+" has sent you a message"});
        });
      } catch (error) {
        console.log('error in try catch',error);

      }
      
      
      const pushNotificationStatus = await sendPushNotification(data.receiver_id, type="to_client_message");
      // console.log(pushNotificationStatus, 'test wait');
      if(data.room_id == data.sender_id){
        const textSmsStatus = await sendPushNotification(data.receiver_id,type="to_dietitian_message",{dietician_id: data.receiver_id, client_id: data.sender_id});
      } 
      // send SMS to dietitian about new message

      seenStatus = false;
    });
  });

  // event to save seen status
  socket.on('seen-status', (data) => {
    var statusCheck;
    // below condition is set to hit the db once only
    // if the seen status is false, then only update the database.
    if (!seenStatus) {
      const updateSeenStatusQuery = `UPDATE ${tableName} SET seen_status = ? WHERE receiver_id = ? AND room_id = ? ORDER BY id DESC LIMIT 1`;
      const seenValues = [
        data.status,
        data.userId,
        data.room_id
      ];
      pool.query(updateSeenStatusQuery, seenValues, (seenQueryError, seenQueryResults) => {
        if (seenQueryError) {
          console.error('Error updating seen status:', seenQueryError);
          statusCheck = seenQueryError;
          seenStatus = true;
        } else {
          // console.log('Seen status updated to 1 for the latest message with received_id 54');
          statusCheck = data.userId;
          seenStatus = true;
        }
        socket.emit('seen-status', statusCheck);
      });
      io.to(data.userId).emit('message-notification', false);
    }
  })
  // Listen for disconnections
  // socket.on('disconnect', () => {
  //   console.log('A user disconnected');

  //   onlineUsers--;
  //   io.emit('userCount', onlineUsers);

  //   socket.leave(room);
  // });

  // Event listener for disconnection
  socket.on('disconnect', () => {
    console.log('Client disconnected');
    userSocketMap.delete(socket.id);
    io.emit('refresh_status');
    console.log(io.engine.clientsCount, " on disconnect ");
  });

  // sent/received files
  socket.on('sent-files', (id) => {
    // console.log("files");
    // get file path sent/recieved in chat
    // $getSentFilePath = DB::table('message')->select('message','created_at')->where('type', '2')->where('receiver_id', $id)->orderByDesc('id')->get();
    const getSentFilePath = `SELECT message, milli_timestamp as created_at FROM ${tableName} WHERE type = 2 AND receiver_id = ? ORDER BY id DESC`;
    [pool.query(getSentFilePath, id, (error, results) => {
      if (error) {
        console.log('Error fetching chat history:', error);
        return;
      }
      if (results.length > 0) {
        console.log(results[0],"line number 205");
      }

    })]
    // $getReceivedFilePath = DB::table('message')->select('message','created_at')->where('type', '2')->where('sender_id', $id)->orderByDesc('id')->get();
  })

  // message reaction listener
  socket.on('message-reaction', (data) => {
    console.log('message-reaction Event hit 214');
    try {
      // var match = data.reaction.match(/^(.+)_(\d+)$/);
      const addUpdateReactQuery = `UPDATE ${tableName} SET reaction = CASE WHEN reaction = ? THEN null ELSE ? END WHERE id = ?`;
      const values = [
        encodeURI(data.emoji),
        encodeURI(data.emoji),
        data.reaction,
      ];
      pool.query(addUpdateReactQuery, values, (error, result) => {
        // console.log(data.details.roomId);
        if (error) {
          console.log(error,"line number 226");
          socket.emit('error', "Something went wrong in upding the reaction");
        } else {
          const resultData = {
            emoji: safeDecodeURI(data.emoji),
            id: data.reaction
          }
          // console.log(result);
          reactionStatusquery = `SELECT *,created_at AS timestamps, milli_timestamp AS created_at FROM ${tableName} WHERE id = ?`;
          pool.query(reactionStatusquery, data.reaction, (reactionQueryError, reactionQueryResult) => {
            if (reactionQueryError) {
              // console.log(reactionQueryError);
              socket.emit('error', "Something went wrong in upding the reaction");
            } else {
              const decodedResults = reactionQueryResult.map((result) => {
                // const isGreaterThan30Min = check30minFromNow(result.created_at);
                return {
                  ...result,
                  message: safeDecodeURI(result.message),
                  reaction: safeDecodeURI(result.reaction),
                  checkRoomID: data.roomId,
                  menu: check30minFromNow(result.created_at) ? ['Reaction'] : ['Reaction', 'Edit', 'Delete'],
                  test: 'check test',
                };
              });
              console.log("Message 271 Reaction Fetched Data in Result: ", decodedResults[0]['receiver_id']);
              // send push notification to user on app.
              if(decodedResults[0]['reaction'] != 'null' && decodedResults[0]['room_id'] == decodedResults[0]['sender_id']){
                // below is for dot notification in app
                io.to(String(decodedResults[0]['room_id'])).emit('message-notification', true);
                // send push notification to app
                console.log("test message reaction.........",decodedResults[0]);
                sendPushNotification(decodedResults[0]['sender_id'], type="reacted")
              }
              if(decodedResults[0]['room_id'] != decodedResults[0]['sender_id'] && decodedResults[0]['reaction'] != 'null'){
                try {
                  query = `SELECT name, role FROM users WHERE id = ?`;
                  const values = [
                    decodedResults[0]['sender_id']
                  ];
                  pool.query(query, values, (error, result) => {
                    if (error) {
                      console.log(error);
                    }
                    if(result){
                      console.log(result, "line 353 ")
                      if(result[0]['role'] != 3){
                        console.log(result[0]['role']," get name by Id");
                        // sendPushNotification(decodedResults[0]['sender_id'], type="reacted-client", null, room_id=decodedResults[0]['room_id'])
                        io.to(decodedResults[0]['sender_id']).emit('message-notifications', {"id":decodedResults[0]['room_id'], "name":result[0]['name'], "message":result[0]['name']+" Reacted on a message"});
                      }
                    }else{
                      console.log('test notification not to admin')
                    }
                  });
                } catch (error) {
                  console.log(error); 
                }
              }
              // socket.emit('reaction-status', decodedResults[0]);
              console.log(decodedResults[0]," line number 252")
              io.to(String(data.roomId)).emit('message-reaction', decodedResults[0]);
            }
          })
        }
      })
    } catch (error) {
      console.log(error.message, " line 259");
      socket.emit('error', "Not Allowed 400");
    }
  });

  // handle delete message
  socket.on('delete-message', (data) => {
    console.log('Delete Event hit 266');
    try {
      // console.log(data.messageId," Delete message id");
      const query = `UPDATE ${tableName} SET deleted = ? WHERE id = ?`;
      const values = [
        'true',
        data.messageId,
      ];
      pool.query(query, values, (error, result) => {
        if (error) {
          console.log(error," line number 276");
          socket.emit('error', "Something went wrong in deleting the message");
        }
        data.status = true;
        io.to(String(data.roomId)).emit('delete-message', data);
      });
      console.log("succes hit 282");
    } catch (error) {
      console.log(error.message, " line 284");
      data.status = false;
      socket.emit('delete-message', data);
      console.log("error in deleting 287", error.message);
    }
  });

  // Update Message
  socket.on('update-message', (data) => {
    console.log('update-message Event hit 293');
    try {
      const updated_at = Date.now();
      const query = `Update ${tableName} SET message = ?, edited = ?, milli_timestamp = ? WHERE id = ?`;
      const values = [
        encodeURI(data.message),
        1,
        updated_at,
        data.msgId,
      ];
      pool.query(query, values, (error, result) => {
        if (error) {
          console.log(error," 305 line");
          socket.emit('error', "Something went wrong in updating the message");
          const updatedata = {
            status: false,
            message: null,
            updated_at: null,
            edited: null,
          }
        } else {
          pool.query(`SELECT *,created_at AS timestamps, milli_timestamp AS created_at from ${tableName} where id=?`, data.msgId, (error2, result2) => {
            if (error2) {
              return console.log('error in retrieving data 316', error2)
            } else {
              const updatedata = {
                ...result2[0],
                reaction: safeDecodeURI(result2[0].reaction),
                status: true,
                message: safeDecodeURI(result2[0].message),
                updated_at: updated_at,
                menu: check30minFromNow(result.created_at) ? ['Reaction'] : ['Reaction', 'Edit', 'Delete'],
              }
              io.to(String(data.roomId)).emit('update-message', updatedata);
              console.log("success 327", result);
              console.log('query result 328: ', updatedata)
            }
          })
          // console.log('update successfully', result)
        }
      })
      console.log('success 334');
    } catch (error) {
      console.log('error 336', error.message);
    }

  })
});








// Handle image upload endpoint
// app.post('/upload', upload.single('image'), (req, res) => {
//   try {
//     if (!req.file) {
//       return res.status(400).send({
//         success: false,
//         data: null,
//         message: "Not Uploaded"
//       });
//     }
//     // Return the relative path to the uploaded image
//     res.send({
//       success:true,
//       data: req.file.filename,
//       message:"success",
//     });
//   } catch (error) {
//     res.send({
//       success:false,
//       data: error.message,
//       message:"success",
//     });
//   }
// });
app.post('/upload', upload.single('image'), (req, res) => {
  try {
    console.log("coming here 368");
    if (!req.file) {
      return res.status(400).send({
        success: false,
        data: null,
        message: "Not Uploaded"
      });
    }

    res.json({
      success: true,
      data: req.file.filename,
      message: "success",
    });
  } catch (error) {
    res.json({
      success: false,
      data: error.message,
      message: "error",
    });
  }
});

const Server = http.listen(3000, () => {
  console.log('Server is listening on port 3000');
});

// process.on('SIGINT', ()=>{
//   console.log('Signal interupted');
//   Server.close();
// });
// process.on('SIGTERM',()=>{
//   Server.close();
// });

// functions
function sendPushNotification(id, type=null,dietician_id=null,room_id=null) {
  return { status: false, message: 'Not Sent' } ;
  let body_data;
  console.log(room_id);
  if(dietician_id != null && dietician_id.client_id){
    body_data = {
      "dietician_id": dietician_id.dietician_id,
      "client_id": dietician_id.client_id
    }
    console.log("473 client to admin", dietician_id, body_data)
  }else{
    body_data = {
      "dietician_id": null,
      "client_id": null
    }
    console.log("line 485");
  }

  try {
    fetch('https://demo.dtlavleen.online/api/check-push-notification', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        ...body_data,
        receiver_id: id,
        type: type,
        room_id: room_id,
        // dietician_id: dietician_id.dietician_id ? dietician_id.dietician_id : null,
        // client_id: dietician_id.client_id ? dietician_id.client_id : null,
      }),
    })
      .then((response) => response.json()).then(data => console.log(data, "API Data"))
      .catch((error) => {
        console.error('Error making API request:', error);
      });
  } catch (error) {
    console.log(error.message,'try catch error 420')
  }
}

// check message time from now for 30 min
function check30minFromNow(messageTime) {
  return isGreaterThan30Min = Date.now() - parseInt(messageTime) > 30 * 60 * 1000;
}

function checkUserSideNewMessage(room){
  return new Promise((resolve, reject)=>{
    const query = `SELECT seen_status FROM ${tableName} WHERE receiver_id = ? ORDER BY id DESC LIMIT 1`;
    pool.query(query, room, (error, result)=>{
      if(error){
        // console.log(error,' error message in getting the seen status when user connected 434')
        // returning false to handle the error on socket side.
        // reject(error);
        // console.log('DB Error: error in fetching seen status from DB 437');
        resolve(false);
      }
      if(result && result.length >0){
        let data = result[0].seen_status == '0' ? true : false;
        resolve(data);
      }else{
        // console.log('Empty Result: Not Found in DB 444')
        resolve(false);
      }
    });
  }) 
}


function convertToMilliseconds(dateString) {
  const date = new Date(dateString);
  return date.getTime();
}

function testUploadFile(){
  
}

// function updateOnline(socketId,userId){
//     if(socketId && userId){
//       const query = `UPDATE users SET chat_online_status = ? WHERE id = ?`;
//       const values = [
//         socketId,
//         userId,
//       ];
//       pool.query(query,values,(error,result)=>{
//         if(error){
//           console.log(error, "unable to update online status line 68");
//           return;
//         }
//         return 1;
//       })
//     }
//     return;
// }
// function updateOffline(socketId){
//   if(socketId && userId){
//     const query = `UPDATE users SET chat_online_status = ? WHERE chat_online_status = ?`;
//     const values = [
//       null,
//       socketId,
//     ];
//     pool.query(query,values,(error,result)=>{
//       if(error){
//         console.log(error, "unable to update online status line 68");
//         return;
//       }
//       return 0;
//     })
//   }
//   return;
// }


function safeDecodeURI(uri) {
  try {
    return decodeURI(uri);
  } catch (e) {
    console.error("Error decoding URI:", uri, e);
    return uri; // Return the original value if decoding fails
  }
}