// Connect to the Socket.IO server
const socketUrl = "https://demochat.dtlavleen.online";
// const socketUrl = "https://35.154.150.63:3000/";
var socket = io(socketUrl);
const statusElement = document.getElementById('status');
async function getParameters() {
    const sender_id = getParameterByName('dietician_id');
    const receiver_id = getParameterByName('id');
    const name = getParameterByName('name');
    const user_name = getParameterByName('user_name');
    const roomId = getParameterByName('id')+'1';

    const userDataDetails = {
        sender_id,
        receiver_id,
        name,
        user_name,
        roomId
    };
    return userDataDetails;
}

const clientDetails = getParameters();
socket.on('connect', () => {
    $('.text-message').prop('disabled', false);
    $('.selected-file').hide();
    $('.selected-file').empty();
    async function emitUserDataDetails() {
        try {
            const userDataDetails = await getParameters();
            socket.emit('userDataDetails', userDataDetails);
            // Create a room based on the client's ID
            const room = getParameterByName('id')+'1';
            // Use the 'join' method to join the room
            socket.emit('joinRoom', room);
            socket.emit('get_online_status',{"receiver_id":getParameterByName('id'),"roomId":getParameterByName('id')+'1'});
            socket.emit('seen-status', {status: 1, userId:getParameterByName('dietician_id'), room_id:room});
        } catch (error) {
            alert("Error in connection");
            console.error('Error fetching parameters:', error);
        }
    }
    emitUserDataDetails();
});

socket.on('get_online_status',(data)=>{
    // console.log("check user online status : ",data);
    if(data.status == 1){
        statusElement.textContent = 'Online';
        statusElement.classList.remove('red-text');
        statusElement.classList.add('green-text');
    }else{
        // console.log("check 0");
        statusElement.textContent = 'Offline';
        statusElement.classList.remove('green-text');
        statusElement.classList.add('red-text');
    }
})

socket.on('message-notificationsss',(data)=>{
    console.log(data, "from js");
})

socket.on('refresh_status',()=>{
    // console.log("refresh event");
    socket.emit('get_online_status',{"receiver_id":getParameterByName('id'),"roomId":getParameterByName('id')+'1'});
});

socket.on('disconnect', () => {
    statusElement.textContent = 'Offline';
    // Emit a custom event to the server for leaving the room
    console.log("disconnect");
    $('.text-message').prop('disabled', true);
    $('.selected-file').show();
    $('.selected-file').html("<b style='align-text:center'>No Connection with server!<b>");
});
socket.on('reconnect', function (attemptNumber) {
    $('.selected-file').html("Connected");
    console.log('Reconnected to server after ' + attemptNumber + ' attempts');
});
// Event listener for reconnection error
socket.on('reconnect_error', function (error) {
    console.error('Reconnection error:', error.message);
});
// Event listener for reconnection attempt
socket.on('reconnect_attempt', function (attemptNumber) {
    console.log('Attempting to reconnect (' + attemptNumber + ')');
});
// Event listener for maximum reconnection attempts
socket.on('reconnect_failed', function () {
    console.error('Maximum reconnection attempts reached. Reloading the page.');
    location.reload();
});
// socket.on('message-notification', (data)=>{
// console.log(" flag 1 ", data)
// });

// Event for files
const attachment = $('.attachment-file');
const selectedFile = $('.selected-file');

attachment.on('change', function () {
    var img = $(this).val();
    if (img) {
        var fileExtension = img.split('.').pop().toLowerCase();
        // condition to check selected file extension
        const fileExtensions = ['pdf', 'jpg', 'jpeg', 'png', 'mp4', 'mp3'];
        if (fileExtensions.includes(fileExtension)) {
            // if (fileExtension === 'pdf' || fileExtension === 'jpg' || fileExtension === 'jpeg' || fileExtension === 'png' || fileExtension === 'mp4' || fileExtension === 'mp3') {
            // Extract only the file name
            var fileName = img.replace(/^.*[\\\/]/, '');
            selectedFile.show();
            selectedFile.html(fileName);
            sendButton.disabled = false;
        } else {
            // Invalid file extension
            alert("Invalid file format. Please upload a PDF, JPG, JPEG, or PNG file.");
            // Disable sendButton if the file extension is invalid
            sendButton.disabled = true;
        }
    } else {
        // No file selected, remove the content and disable sendButton
        selectedFile.empty();
        selectedFile.hide();
        document.getElementById('text-message').disabled = true;
    }
});


// Add a click event listener to the send button
var sendButton = document.querySelector('.send-button');
sendButton.addEventListener('click', function () {
    var message = $('.text-message').val();
    var checkFileAttachment = $('.attachment-file').val();
    if (message || checkFileAttachment) {
        // Emit the chat message to the server
        if (message) {
            const messageObj = sendMessage();
            socket.emit('send-message', messageObj);
        }
        if (checkFileAttachment) {
            uploadImage();
        }

    } else {
        // Handle the case where both message and file are empty
        console.log("Please enter a message or attach a file.");
    }
});

const messageAdmin = document.getElementById('text-message');
// Disable the send button initially
sendButton.disabled = true;
// Add input event listener to the textarea
messageAdmin.addEventListener('input', function () {
    // Check if the textarea is empty
    if (messageAdmin.value.trim() === '') {
        // If empty, disable the send button
        sendButton.disabled = true;
        document.getElementById('sendButtonIcon').classList.remove('color-green');
    } else {
        // If there is input, enable the send button
        sendButton.disabled = false;
        document.getElementById('sendButtonIcon').classList.add('color-green');
    }
});
// Show chat message from Admin
const textmessage = document.getElementById('text-message');
socket.on('add-messages', (data) => {
    // console.log(data, "on add-message");
    if (data.sender_id == getParameterByName('dietician_id')) {
        appendMessage(data.name, data.message, data.image, data.created_at, 'left', data.userType, data.id, data.menu, data.edited);
    } else {
        socket.emit('seen-status', {status: 1, userId:getParameterByName('dietician_id'), room_id:data.room_id});
        appendMessage(data.name, data.message, data.image, data.created_at, 'right', data.userType, data.id, data.menu, data.edited);
    }
    scrollToBottom(100);
});

//To show chat History users and admin
socket.on('chatHistory', (history) => {
    const messagesContainer = document.getElementById('messages');
    messagesContainer.innerHTML = '';
    history.chat.forEach((message) => {
        message.reaction = message.reaction == 'null' ? '' : message.reaction;
        const userType = message.userType;
        const menuShowHide = message.menu.length === 3 ? 'display-block' : 'display-none';

        if (message.sender_id != history.client) {
            appendHistoryMessage(message.name, message.message, message.image, message.created_at, 'right', 'user', message.id, message.reaction, message.menu, message.edited, 'display-block');
        } else {
            appendHistoryMessage(message.name, message.message, message.image, message.created_at, 'left', 'admin', message.id, message.reaction, message.menu, message.edited, menuShowHide);
        }
    });
    scrollToBottom(500);
});

// Event to update the seen status
// var chatAreaDiv = document.getElementById('messages');
// chatAreaDiv.addEventListener('mouseenter', function (event) {
//     data = {
//         status: 1,
//         userId: getParameterByName('dietician_id')
//     }
//     socket.emit('seen-status', data);
// });

socket.on('seen-status', (data) => {
    // for test only or to perform any action
    // console.log(data);
});

// listen error
socket.on('error', (data) => console.log(data))

// Listener for reaction
socket.on('message-reaction', (data) => {
    var reactedDiv = $(`.reacted[data-id="${btoa(data.id)}"]`);
    reactedDiv.fadeOut(300, function () {
        // console.log(typeof data.reaction, data.reaction, 'testng')
        if (data.reaction != 'null') {
            reactedDiv.text(data.reaction);
            reactedDiv.fadeIn(300);
        } else {
            reactedDiv.text('');
            reactedDiv.fadeIn(300, function () {
                // This code will run after the fade-in animation is completed
                reactedDiv.removeAttr('style');
                reactedDiv.css('display', 'none !important');
            });
        }
    });
});

// update message
socket.on('update-message', (data) => {
    const alignment = data.room_id == data.sender_id ? 'right' : 'left';
    updateMessage(data.id, data.message, formatDateMilliSecond(data.created_at), data.edited, data.menu, data.reaction, alignment);
});

// delete message
socket.on('delete-message', (data) => {
    if (data.status) {
        data.messageId = btoa(data.messageId);
        // document.querySelector('.'+data.messageId).remove();
        var elementToRemove = $('.' + $.escapeSelector(data.messageId));
        elementToRemove.fadeOut(500, function () {
            elementToRemove.remove();
        });
    } else {
        console.log('Unable to reach server');
    }
});

/*Date-Time format*/
// function getCurrentFormattedDate() {
//     const { DateTime } = luxon;
//     const currentDate = DateTime.now().setZone('Asia/Kolkata');
//     const day = currentDate.toFormat('dd');
//     const month = currentDate.toFormat('MM');
//     const year = currentDate.toFormat('yyyy');
//     const hours = currentDate.toFormat('hh'); // Use 'hh' for 12-hour format
//     const minutes = currentDate.toFormat('mm');
//     const ampm = currentDate.toFormat('a');
//     const formattedDate = `${day}/${month}/${year} ${hours}:${minutes} ${ampm}`;
//     return formattedDate;
// }
function getCurrentFormattedDate() {
    const { DateTime } = luxon;
    const currentDate = DateTime.local(); // This will use the local timezone
    const day = currentDate.toFormat('dd');
    const month = currentDate.toFormat('MM');
    const year = currentDate.toFormat('yyyy');
    const hours = currentDate.toFormat('hh'); // Use 'hh' for 12-hour format
    const minutes = currentDate.toFormat('mm');
    const ampm = currentDate.toFormat('a');
    const formattedDate = `${day}/${month}/${year} ${hours}:${minutes} ${ampm}`;
    return formattedDate;
}

function getParameterByName(name) {
    url = window.location.href;
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));
}

// Function to scroll to the bottom of the chat
function scrollToBottom(miliseconds=500) {
    const messagesContainer = document.getElementById('messages');
    setTimeout(() => {
        messagesContainer.scrollTop = messagesContainer.scrollHeight;
    },miliseconds);
    // var ul = document.querySelector('#messages');
    // var lastLi = ul.lastElementChild;
    // if(lastLi){
    //     console.log(lastLi);
    //     lastLi.scrollIntoView({ behavior: 'smooth', block: 'end' });
    // }
}

//Message Sending
function sendMessage() {
    const messageInput = document.getElementById('text-message');
    let message = messageInput.value.trim();
    // message = message.replace(/ /g, '&nbsp;').replace(/\n/g, '<br/>');
    messageInput.value = '';
    document.getElementById('sendButtonIcon').classList.remove('color-green');
    const senderID = getParameterByName('dietician_id');
    const receiverID = getParameterByName('id');
    const room = getParameterByName('id')+'1';
    var date = Date.now();
    const messageObj = {
        room_id: room,
        sender_id: senderID, // Replace with the actual sender ID
        receiver_id: receiverID,
        name: getParameterByName('name'),
        message: message,
        type: 1, // Type 1 represents text message
        seen_status: 0,
        userType: 'admin',
        created_at: date,
    };
    return messageObj
}

//File Sending By Admin 
function uploadImage() {
    var date = Date.now();
    const fileInput = document.getElementById('attachment-file');
    const file = fileInput.files[0];
    if (!file) {
        return;
    }
    // Create a FormData object to send the file
    const formData = new FormData();
    formData.append('image', file);
    // Send the image to the server using fetch API
    fetch('/upload', {
        method: 'POST',
        body: formData,
    })
        .then((response) => response.json())
        .then((result) => {
            if (result.success) {
                // console.log(result.data);
                const senderID = getParameterByName('dietician_id');
                const receiverID = getParameterByName('id');
                const room = getParameterByName('id')+'1';
                const messageObj = {
                    room_id: room,
                    sender_id: senderID,
                    receiver_id: receiverID,
                    name: getParameterByName('name'),
                    message: result.data,  // Use the uploaded file path
                    image: result.data,
                    type: 2,
                    seen_status: 0,
                    userType: 'admin',
                    created_at: date,
                    name: getParameterByName('name')
                };

                // Clear the file input after successful upload
                selectedFile.empty();
                selectedFile.hide();
                fileInput.value = '';
                document.getElementById('sendButtonIcon').classList.remove('color-green');
                socket.emit('send-message', messageObj);
            } else {
                console.error('Error uploading image:', result.message);
            }
        })
        .catch((error) => {
            console.error('Error uploading image:', error);
        });
}


function appendHistoryMessage(name, message, file, created_at, alignment, isAdmin, dataId, reaction = '', menu, edited = false, menuShowHide) {
    file && (file = "uploads/" + file);
    dataId && (dataId = btoa(dataId));
    edited = (edited == 1) ? 'Edited ' : '';
    reactionClass = alignment == 'right' ? 'emoji-send' : '';
    const messagesContainer = document.getElementById('messages');
    const messageElement = document.createElement('div');
    messageElement.classList.add(dataId);
    const baseFileName = file ? file.split('/').pop() : '';// Extract base file name before the timestamp
    const match = baseFileName.match(/^(.*)-\d+\.pdf$/);
    const extractedName = match && match[1] ? match[1].trim() : '';
    const fileExtension = baseFileName ? baseFileName.split('.').pop() : '';
    const messageContent = file ? `${(file.endsWith(".pdf")) ? `<span class="preview-file" data-src="${file}"><img class="pdfIcon" src="asset/icons/pdfIcon.png"><span class="pdf-name">${extractedName}.${fileExtension}</span></span>` : (file.endsWith(".mp4")) ? `<video class="mediaPlayer" width="320" height="240" controls controlsList="nodownload"><source src="${file}" type="video/mp4">Your browser does not support the video tag.</video>` : file.endsWith(".mp3") ? `<audio class="mediaPlayer" controls controlsList="nodownload noplaybackrate novolume"><source src="${file}" type="audio/mp3">Your browser does not support the audio tag.</audio>` : `<span class="preview-file" data-src="${file}"><img class="img-tag" src="${file}" alt="Image"></span>`}` : message.trim();
    const userOrAdmin = isAdmin == 'admin' ? 'admin' : 'user';
    const iconClassMsgOption = isAdmin == 'admin' ? 'fa-ellipsis-v' : 'fa-smile-o';
    const formattedDate = formatDateMilliSecond(created_at);
    const messageLayout = `
            <li class="${userOrAdmin}-message-container ${alignment}-align message-box">
                <div class="${userOrAdmin}-name">
                    <p>${name}</p>
                </div>
                <div class="${userOrAdmin}-message text-message-container" data-id="${dataId}">
                    <i class="menu-message message-menu-option fa ${iconClassMsgOption} ${menuShowHide}" aria-hidden="true"></i>
                    <div class="${reactionClass} emoji">
                        <ul>
                            <li class="emoji-reaction" data-value="thumb-up_${dataId}">👍🏻</li>
                            <li class="emoji-reaction" data-value="smile_${dataId}">😊</li>
                            <li class="emoji-reaction" data-value="heart_${dataId}">❤️</li>
                            <li class="emoji-reaction" data-value="sad_${dataId}">🙁</li>
                            <li class="emoji-reaction" data-value="folded-hands_${dataId}">🙏🏻</li>
                            <li class="emoji-reaction" data-value="laugh_${dataId}">😀</li>
                            <li class="emoji-reaction" data-value="celebration_${dataId}">🎉</li>
                            <li class="emoji-reaction" data-value="blessed_${dataId}">😇</li>
                        </ul>
                    </div>
                    <ul class="message-edit">
                        ${menu.length === 3 && alignment === 'left' && file === null ? `
                        <li class="edit" data-value="${dataId}">${menu[1]}</li>
                        <li class="delete" data-value="${dataId}">${menu[2]}</li>
                    ` : (menu.length === 3 && alignment === 'left' && file !== null) ? `
                            <li class="delete" data-value="${dataId}">${menu[2]}</li>
                        ` : ``}
                    </ul>
                    <pre>${linkify(messageContent)}</pre>
                    <div class="message-time">
                        <p>${edited + formattedDate}</p>
                    </div>
                    <div class="reacted" data-id="${dataId}">${reaction}</div>
                </div>
            </li>`
        ;
    messageElement.innerHTML = messageLayout;
    messagesContainer.appendChild(messageElement);
}

function appendMessage(name, message, file = null, created_at, alignment, isAdmin, dataId, menu, edited = false, menuShowHide) {
    file && (file = "uploads/" + file);
    // console.log(file, "test ");
    dataId && (dataId = btoa(dataId));
    edited = (edited == 1) ? 'Edited ' : '';
    reactionClass = alignment == 'right' ? 'emoji-send' : '';
    const menuOptionClass = menu.length === 3 ? 'menu-message' : 'menu-messages';
    const messagesContainer = document.getElementById('messages');
    const messageElement = document.createElement('div');
    messageElement.classList.add(dataId);
    const baseFileName = file ? file.split('/').pop() : '';// Extract base file name before the timestamp
    const match = baseFileName.match(/^(.*)-\d+\.pdf$/);
    const extractedName = match && match[1] ? match[1].trim() : "No match found.";
    const fileExtension = baseFileName ? baseFileName.split('.').pop() : '';
    const iconClassMsgOption = isAdmin == 'admin' ? 'fa-ellipsis-v' : 'fa-smile-o';
    const messageContent = file

        ? (file.endsWith(".pdf")
            ? `<span class="preview-file" data-src="${file}"><img class="pdfIcon" src="asset/icons/pdfIcon.png"><span class="pdf-name">${extractedName}.${fileExtension}</span></span>`
            : file.endsWith(".mp4")
                ? `<video class="mediaPlayer" width="320" height="240" controls controlsList="nodownload"><source src="${file}" type="video/mp4">Your browser does not support the video tag.</video>`
                : file.endsWith(".mp3")
                    ? `<audio class="mediaPlayer" controls controlsList="nodownload noplaybackrate novolume"><source src="${file}" type="audio/mp3">Your browser does not support the audio tag.</audio>`
                    : `<span class="preview-file" data-src="${file}"><img class="img-tag" src="${file}" alt="Image"></span>`)
        : message.trim();

    const userOrAdmin = isAdmin == 'admin' ? 'admin' : 'user';
    const messageLayout = `
            <li class="${userOrAdmin}-message-container ${alignment}-align message-box">
                <div class="${userOrAdmin}-name">
                <p>${name}</p>
                </div>
                <div class="${userOrAdmin}-message text-message-container" data-id="${dataId}">
                    <i class="menu-message message-menu-option fa ${iconClassMsgOption} ${menuShowHide}" aria-hidden="true"></i>
                    <div class="${reactionClass} emoji">
                        <ul>
                            <li class="emoji-reaction" data-value="thumb-up_${dataId}">👍🏻</li>
                            <li class="emoji-reaction" data-value="smile_${dataId}">😊</li>
                            <li class="emoji-reaction" data-value="heart_${dataId}">❤️</li>
                            <li class="emoji-reaction" data-value="sad_${dataId}">🙁</li>
                            <li class="emoji-reaction" data-value="folded-hands_${dataId}">🙏🏻</li>
                            <li class="emoji-reaction" data-value="laugh_${dataId}">😀</li>
                            <li class="emoji-reaction" data-value="celebration_${dataId}">🎉</li>
                            <li class="emoji-reaction" data-value="blessed_${dataId}">😇</li>
                        </ul>
                    </div>
                    <ul class="message-edit">
                        ${menu.length === 3 && alignment === 'left' && file === null ? `
                        <li class="edit" data-value="${dataId}">${menu[1]}</li>
                        <li class="delete" data-value="${dataId}">${menu[2]}</li>
                    ` : (menu.length === 3 && alignment === 'left' && file !== null) ? `
                            <li class="delete" data-value="${dataId}">${menu[2]}</li>
                        ` : ``}
                    </ul>
                    <pre>${linkify(messageContent)}</pre>
                    <div class="message-time">
                    <p>${edited + formatDateMilliSecond(created_at)}</p>
                    </div>
                    <div class="reacted" data-id="${dataId}"></div>
                </div>
            </li>`
        ;
    // messagesContainer.innerHTML += messageLayout;
    messageElement.innerHTML = messageLayout;
    messagesContainer.appendChild(messageElement);
}

function formatDate(inputDate) {
    const date = new Date(inputDate);
    const day = date.getUTCDate().toString().padStart(2, '0');
    const month = (date.getUTCMonth() + 1).toString().padStart(2, '0');
    const year = date.getUTCFullYear();
    let hours = date.getUTCHours();
    const minutes = date.getUTCMinutes().toString().padStart(2, '0');
    const ampm = hours >= 12 ? 'PM' : 'AM';
    // Convert hours to 12-hour format
    hours = hours % 12;
    hours = hours ? hours : 12; // '0' should be converted to '12'
    const formattedDateTime = `${day}/${month}/${year}, ${hours.toString().padStart(2, '0')}:${minutes} ${ampm}`;
    return formattedDateTime;
}
function formatDateMilliSecond(timestamps) {
    const dateObject = new Date(parseInt(timestamps));
    let formattedDate = new Intl.DateTimeFormat('en-IN', {
        day: 'numeric',
        month: 'numeric',
        year: 'numeric',
        hour: 'numeric',
        minute: 'numeric',
        hour12: true  // Use 12-hour clock with AM/PM
    }).format(dateObject);
    return formattedDate;
}




/**
 * Event Handler Functionality For,
 * Edit/Delete/Hide/Reaction/controls/file-handle For a Message,
 * 
 */

// Event to open message menu options
var test=1;
$(document).on("click", ".message-menu-option", function () {
    $(".emoji-send").hide();
    $(".message-edit").hide();
    var messageContainer = $(this).closest("li");
    messageContainer.find(".message-edit").toggle();
    messageContainer.find(".emoji-send").show();
});
// Event to open emoji reaction tab
// this step is removed from message box
// $(document).on("click", ".react", function () {
//     var messageContainer = $(this).closest(".message-box");
//     // Hide all .message-edit elements if opened
//     $(".message-edit").hide();
//     messageContainer.find(".emoji-send").show();
// });
// Event to add emoji reaction to a message.
$(document).on("click", ".emoji-reaction", async function (e) {
    const reationName = $(this).data("value").split("_");
    const data = {
        roomId: getParameterByName('id')+'1',
        reaction: atob(reationName[1]),
        emoji: $(this).text(),
    };
    if ($(this).data("value") != '') {
        socket.emit('message-reaction', data);
    }
    $(".emoji-send").hide();
});
// Event to handle show hide of message edit menu by clicking anywhere
$(document).on("click", "body .container", function (event) {
    if ($(event.target).hasClass("message-menu-option") || $(event.target).hasClass("react") || $(event.target).hasClass("emoji-reaction") || $(event.target).hasClass(".edit") || $(event.target).hasClass(".delete")) {
        // Do nothing if the click is on .message-menu-option or .react
        return;
    }
    // hide menu when user click outside
    $(".message-edit, .emoji-send").hide();
});

// delete message event
$(document).on('click', '.delete', function () {
    const data = {
        messageId: atob($(this).data("value")),
        roomId: getParameterByName('id')+'1',
    }
    Swal.fire({
        title: 'Confirm Deletion',
        text: "Are you sure you want to delete this message?",
        // icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'No, cancel!'
    }).then((result) => {
        if (result.isConfirmed) {
            socket.emit('delete-message', data);
        }
    });
    // socket.emit('delete-message', data)
})

// edit message event
$(document).on('click', '.edit', function () {
    const textMsgBox = $(this).closest('.text-message-container');
    // conditional base check for the html of text-box
    const dataId = textMsgBox.data('id');
    const textMsgBoxInnerHTML = textMsgBox.html()
    const preTagText = textMsgBox.find('pre').text();
    textMsgBox.empty();

    textMsgBox.append(`
        <div class="editSentMessage">
            <textarea type="text" class="edit-sent-message" id="edit-sent-message">${preTagText}</textarea>
            <div class="edit-msg-button">
                <span class="cancel-edit-msg">Cancel</span>
                <span class="submit-edit-msg">Update</span>
            </div>
        </div>
    `)
    const textarea = $('.edit-sent-message');
    $('.text-message-container, .admin-container').not(textMsgBox).css({ 'pointer-events': 'none' });
    // Handle cancel button click
    $('.cancel-edit-msg').on('click', function () {
        $('.text-message-container, .admin-container').css({ 'pointer-events': 'auto' });
        textMsgBox.empty();
        textMsgBox.append(textMsgBoxInnerHTML);
        $(".message-edit").hide();
    });

    // Handle update button click
    $('.submit-edit-msg').on('click', function () {
        if(textarea.val() === ''){
            $('.text-message-container, .admin-container').css({ 'pointer-events': 'auto' });
            textMsgBox.empty();
            textMsgBox.append(textMsgBoxInnerHTML);
            $(".message-edit").hide();
        }else{
            $('.text-message-container, .admin-container').css({ 'pointer-events': 'auto' });
            textMsgBox.empty();
            const data = {
                message: textarea.val(),
                msgId: atob(dataId),
                roomId: getParameterByName('id')+'1',
            }
            socket.emit('update-message', data);
        }
    });
    // socket.on("update-message", (data)=>{
    //     if(data.status){
    //         $('.text-message-container, .admin-container').css({ 'pointer-events': 'auto' });
    //         var $textUpdatedMsgBoxInnerHTML = $(textMsgBoxInnerHTML);
    //         $textUpdatedMsgBoxInnerHTML.eq(6).html(data.message);
    //         $textUpdatedMsgBoxInnerHTML.eq(8).html('<p> Edited '+formatDateMilliSecond(data.updated_at)+'</p>');
    //         textMsgBox.empty();
    //         textMsgBox.append($textUpdatedMsgBoxInnerHTML);
    //         $(".message-edit").hide();
    //         $textUpdatedMsgBoxInnerHTML = '';
    //     }else{
    //         $('.text-message-container, .admin-container').css({ 'pointer-events': 'auto' });
    //         textMsgBox.empty();
    //         textMsgBox.append(textMsgBoxInnerHTML);
    //         $(".message-edit").hide();
    //     }
    // });
});

// disabling media settings of video player-controls
$(document).on('contextmenu', '.mediaPlayer', function (e) {
    e.preventDefault();
});

// open sent/recieved file in new tab
$(document).on("click", ".preview-file", function (event) {
    var url = "https://demo.dtlavleen.online/preview";
    window.open(url + '/' + btoa($(this).data('src')), '_blank');
});

// reload after 30 min
function reloadPageAfter30Minutes() {
    const thirtyMinutesInMilliseconds = 30 * 60 * 1000;

    setTimeout(() => {
        location.reload();
    }, thirtyMinutesInMilliseconds);
}

// Call the function to start the countdown
reloadPageAfter30Minutes();

// update message 
function updateMessage(id, message, date, edited = '', menu, reaction, alignment) {
    id = btoa(id);
    edited = (edited == 1) ? 'Edited ' : '';
    reaction = (reaction == 'null') ? '' : reaction;
    reactionClass = alignment == 'right' ? 'emoji-send' : '';
    const textElement = $(`.text-message-container[data-id="${id}"]`);
    const updateHTML = `
        <i class="menu-message message-menu-option fa fa-ellipsis-v" aria-hidden="true"></i>
        <div class="${reactionClass} emoji">
            <ul>
                <li class="emoji-reaction" data-value="thumb-up_${id}">👍🏻</li>
                <li class="emoji-reaction" data-value="smile_${id}">😊</li>
                <li class="emoji-reaction" data-value="heart_${id}">❤️</li>
                <li class="emoji-reaction" data-value="sad_${id}">🙁</li>
                <li class="emoji-reaction" data-value="folded-hands_${id}">🙏🏻</li>
                <li class="emoji-reaction" data-value="laugh_${id}">😀</li>
                <li class="emoji-reaction" data-value="celebration_${id}">🎉</li>
                <li class="emoji-reaction" data-value="blessed_${id}">😇</li>
            </ul>
        </div>
        <ul class="message-edit">
            ${menu.length === 3 && alignment === 'left' ? `
                    <li class="edit" data-value="${id}">${menu[1]}</li>
                    <li class="delete" data-value="${id}">${menu[2]}</li>
                ` : ``}
        </ul>
        <pre>${message}</pre>
        <div class="message-time">
            <p>${edited} ${date}</p>
        </div>
        <div class="reacted" data-id="${id}">${reaction}</div>
    `;
    textElement.html(updateHTML)
}

// function to check text starting from https: to add anchor tag for clickable behaviour in chat inbox
function linkify(messageContent) {
    return messageContent.replace(/(https?:\/\/[^\s]+)/g, function(url) {
        return '<a href="' + url + '" target="_blank">' + url + '</a>';
    });
}